
// ==========================
//  Variabili globali
// ==========================
let tipo_beneficiario = null;
let tipo_cantierabilita = null;
var file_names = {}; // se usi memorizzazione nomi lato server

// ==========================
//  Helper generali
// ==========================
function sanitizeName(s){ return (s||"").toString().trim().replace(/\s+/g,"_").replace(/[^\w.\-]/g,""); }
async function addToZip(zipFolder, fileOrBlob, zipPath){ const ab = await fileOrBlob.arrayBuffer(); zipFolder.file(zipPath, ab); }
async function fetchBlob(url){
  try{ const res = await fetch(url,{credentials:"same-origin"}); if(!res.ok) throw new Error("HTTP "+res.status); return await res.blob(); }
  catch(e){ console.warn("Impossibile scaricare:", url, e); return null; }
}
function bubbleEvent(input, event_type){ const ev = new Event(event_type,{bubbles:true}); input.dispatchEvent(ev); }
function getFormattedDate(date){ const a=date.split("-"); return a[2]+"/"+a[1]+"/"+a[0]; }

// ==========================
//  On load + listeners
// ==========================
$(document).ready(function(){
  switch_anagrafica();
  toggleRegistroIva();
});

// ascolta direttamente i RADIO (non il wrapper)
$(document).on("change", "input[name=tipo_beneficiario]", function(){
  switch_anagrafica();
  toggleRegistroIva();
});

// precompila da Excel
$(document).on("change", ".precompila", async function (event) {
  if (!validate_excel_file($('input[name=verbale_istruttoria]'), '.error_excel')) return;

  const file = event.target.files[0];
  const arrayBuffer = await file.arrayBuffer();
  const workbook = new ExcelJS.Workbook();
  await workbook.xlsx.load(arrayBuffer);
  const worksheet1 = workbook.getWorksheet(1);
  const worksheet2 = workbook.getWorksheet(2);

  const skipping_key = "dati bancari";
  const extracted_anagrafica = {};
  const extracted_localizzazione = { provincia_localizzazione:null, comune_localizzazione:[], foglio:[], particelle:[] };
  const extracted_cantierabilita = { stato:null, titolo:[], richiesto_rilasciato:[], file_titoli:[] };

  read_anagrafica_fields(worksheet1, skipping_key, extracted_anagrafica);
  select_beneficiario(extracted_anagrafica);                 // <-- lancia il change sul radio
  read_localizzazione_fields(worksheet1, extracted_localizzazione);
  read_cantierabilita_fields(worksheet1, worksheet2, extracted_cantierabilita);
  write_anagrafica_fields(extracted_anagrafica);             // usa ID corretti, incluso #cuua_comuni
  write_localizzazione_fields(extracted_localizzazione);
  select_cantierabilita(extracted_cantierabilita);
  write_cantierabilita_fields(extracted_cantierabilita);
});

// ==========================
//  Validazione file Excel
// ==========================
function validate_excel_file(field, error_class){
  var errore_descrizione = field.next(error_class);
  var valore = field[0].files[0];
  var allowedExtensions = /(\.xlsx)$/i;
  var maxSize = 5 * 1024 * 1024;

  if (!allowedExtensions.test(valore.name)) {
    field.addClass("is-invalid");
    errore_descrizione.addClass("invalid-feedback").text("Formato non valido. Caricare solo file .xlsx.");
    return false;
  } else if (valore.size > maxSize) {
    field.addClass("is-invalid");
    errore_descrizione.addClass("invalid-feedback").text("Il file deve essere inferiore a 5MB.");
    return false;
  }
  field.removeClass("is-invalid"); errore_descrizione.removeClass("invalid-feedback").text("");
  return true;
}

// ==========================
//  Lettura dai fogli Excel
// ==========================
function read_anagrafica_fields(worksheet, skipping_key, out){
  worksheet.eachRow((row)=>{
    const key = String(row.getCell(1).value || '').toLowerCase().trim();
    const value = row.getCell(2).value?.toString().trim();
    if (key === skipping_key) return;

    // comuni a tutti
    if (key==="nome" && !out.nome) out.nome=value;
    if (key==="cognome" && !out.cognome) out.cognome=value;
    if (key==="data di nascita" && !out.data_nascita){
      const [g,m,a] = value.split('/'); out.data_nascita = `${a}-${m.padStart(2,'0')}-${g.padStart(2,'0')}`;
    }
    if (key==="luogo di nascita" && !out.luogo_nascita) out.luogo_nascita = value;
    if (key==="provincia di nascita" && !out.provincia_nascita) out.provincia_nascita = value;
    if (key==="cuaa" && !out.cuua) out.cuua = value;
    if (key==="codice fiscale" && !out.codice_fiscale) out.codice_fiscale = value;
    if (key==="residenza" && !out.residenza) out.residenza = value;
    if (key==="provincia" && !out.provincia) out.provincia = value;
    if (key==="indirizzo" && !out.indirizzo) out.indirizzo = value;
    if (key==="civico" && !out.civico) out.civico = value;
    if (key==="telefono/cellulare" && !out.telefono) out.telefono = value;
    if (key==="qualifica" && !out.qualifica) out.qualifica = value;
    if (key==="denominazione" && !out.denominazione) out.denominazione = value;
    if (key==="sede legale" && !out.sede_legale) out.sede_legale = value;
    if (key==="indirizzo sede legale" && !out.indirizzo_sede_legale) out.indirizzo_sede_legale = value;
    if (key==="civico sede legale" && !out.civico_sede_legale) out.civico_sede_legale = value;

    // singoli
    if (key==="provincia di riferimento della cciaa" && !out.provincia_cciaa) out.provincia_cciaa = value;
    if (key==="pec aziendale" && !out.pec) out.pec = value;
    if (key==="mail aziendale" && !out.email) out.email = value;
    if (key==="numero rea" && !out.rea) out.rea = value;
    if (key==="numero iscrizione inps" && !out.inps) out.inps = value;

    // associati + comuni
    if (key==="pec istituzionale" && !out.pec) out.pec = value;
    if (key==="mail istituzionale" && !out.email) out.email = value;

    // associati
    if (key==="n. imprese agricole" && !out.n_imprese) out.n_imprese = value;
    if (key==="provincia sede legale" && !out.provincia_sede_legale) out.provincia_sede_legale = value;

    // comuni
    if (key==="comune di riferimento" && !out.comune_riferimento) out.comune_riferimento = value;
    if (key==="cuaa del comune" && !out.cuaa_comune) out.cuaa_comune = value;
  });
}

function read_localizzazione_fields(ws, out){
  ws.eachRow((row)=>{
    const key = String(row.getCell(1).value || '').toLowerCase().trim();
    const value = row.getCell(2).value?.toString().trim();
    if (key==="provincia di localizzazione" && !out.provincia_localizzazione) out.provincia_localizzazione = value;
    if (key==="comune di localizzazione") out.comune_localizzazione.push(value);
    if (key==="foglio") out.foglio.push(value);
    if (key==="particelle") out.particelle.push(value);
  });
}

function read_cantierabilita_fields(ws1, ws2, out){
  ws1.eachRow((row)=>{
    const key = String(row.getCell(1).value || '').trim();
    const v1 = row.getCell(2).value?.toString().trim();
    const v2 = row.getCell(3).value?.toString().trim();

    if (key==="Stato" && !out.stato) out.stato = v1;
    if (key.includes("Titolo Abilitativo")) out.titolo.push(key.split(': ').length>1 ? key.split(': ')[1].trim() : '');
    if (key.includes("Titolo abilitativo")) out.richiesto_rilasciato.push({richiesto:v1, rilasciato:v2});
  });

  ws2.eachRow((row)=>{
    const key = String(row.getCell(1).value || '').toLowerCase().trim();
    const value = row.getCell(6).value?.toString().trim();
    if (!value) return;
    if (tipo_beneficiario==="associati" && key==="1.11"){
      value.split('\n').forEach(n=> out.file_titoli.push(n));
    } else if (tipo_beneficiario==="singoli" && key==="1.9"){
      value.split('\n').forEach(n=> out.file_titoli.push(n));
    }
  });
}

// ==========================
//  Scrittura nel form
// ==========================
function write_input(el, value){
  if (!el || value === undefined) return;
  el.value = value;
  el.classList.add("from-excel");   // solo per stile/riconoscimento
}

function write_radio(radioButtons, value, callback){
  for (const r of radioButtons){
    const willCheck = (r.value === value);
    r.checked = willCheck;
    if (willCheck && callback) callback(r, "change");
    r.classList.add("from-excel");  // NON disabilito
  }
}

function write_anagrafica_fields(a){
  if (tipo_beneficiario==="associati"){
    write_input(document.getElementById("denominazione_associati"), a.denominazione);
    write_input(document.getElementById("sede_provincia_associati"), a.provincia_sede_legale);
    write_input(document.getElementById("numero_imprese_agricole_associate"), a.n_imprese);
  } else if (tipo_beneficiario==="singoli"){
    write_input(document.getElementById("denominazione_singoli"), a.denominazione);
    write_input(document.getElementById("ccia-riferimento"), a.provincia_cciaa);
    write_input(document.getElementById("numero-rea"), a.rea);
    write_input(document.getElementById("numero-inps"), a.inps !== undefined ? a.inps : "");
  } else if (tipo_beneficiario==="comuni"){
    write_input(document.getElementById("comune_riferimento"), a.comune_riferimento);
    // ✅ ID corretto
    write_input(document.getElementById("cuua_comuni"), a.cuaa_comune);
  }

  write_input(document.getElementById(`nome_${tipo_beneficiario}`), a.nome);
  write_input(document.getElementById(`cognome_${tipo_beneficiario}`), a.cognome);
  write_input(document.getElementById(`data-nascita_${tipo_beneficiario}`), a.data_nascita);
  write_input(document.getElementById(`luogo-nascita_${tipo_beneficiario}`), a.luogo_nascita);
  write_input(document.getElementById(`provincia-nascita_${tipo_beneficiario}`), a.provincia_nascita);
  write_input(document.getElementById(`cuua_${tipo_beneficiario}`), a.cuua);
  if (tipo_beneficiario!=="singoli" && tipo_beneficiario!=="comuni"){
    write_input(document.getElementById(`codice_fiscale_${tipo_beneficiario}`), a.codice_fiscale);
  }
  write_input(document.getElementById(`residenza_${tipo_beneficiario}`), a.residenza);
  write_input(document.getElementById(`provincia_${tipo_beneficiario}`), a.provincia);
  write_input(document.getElementById(`indirizzo_${tipo_beneficiario}`), a.indirizzo);
  write_input(document.getElementById(`civico_${tipo_beneficiario}`), a.civico);
  write_input(document.getElementById(`email_${tipo_beneficiario}`), a.email);
  write_input(document.getElementById(`pec_${tipo_beneficiario}`), a.pec);
  write_input(document.getElementById(`telefono_${tipo_beneficiario}`), a.telefono);
  write_radio(document.getElementsByName(`qualifica_${tipo_beneficiario}`), a.qualifica, bubbleEvent);
  write_input(document.getElementById(`sede_${tipo_beneficiario}`), a.sede_legale);
  write_input(document.getElementById(`sede_indirizzo_${tipo_beneficiario}`), a.indirizzo_sede_legale);
  write_input(document.getElementById(`civico_sede_${tipo_beneficiario}`), a.civico_sede_legale);
}

function write_localizzazione_fields(loc){
  const n = loc.comune_localizzazione.length;
  const inN = document.getElementById("numero_localizzazioni_investimenti");
  const inProv = document.getElementById("provincia-localizzazione");
  write_input(document.getElementById("selezione_province_ispettorato"), loc.provincia_localizzazione);
  write_input(inN, n); bubbleEvent(inN, "input");
  write_input(inProv, loc.provincia_localizzazione); bubbleEvent(inProv, "change");
  for(let i=0;i<n;i++){
    if(i===0){
      write_input(document.getElementById("comune-localizzazione"), loc.comune_localizzazione[i]);
      write_input(document.getElementById("foglio"), loc.foglio[i]);
      write_input(document.getElementById("particella"), loc.particelle[i]);
    }else{
      write_input(document.getElementById(`comune-localizzazione_${i+1}`), loc.comune_localizzazione[i]);
      write_input(document.getElementById(`foglio_${i+1}`), loc.foglio[i]);
      write_input(document.getElementById(`particella_${i+1}`), loc.particelle[i]);
    }
  }
}
function write_cantierabilita_fields(c){
  const n = c.titolo.length;

  if (tipo_cantierabilita === "necessita"){
    for (let i=0; i<n; i++){
      const idx = i === 0 ? "" : `_${i+1}`;
      write_input(document.getElementById(`enti_preposti_input${idx}`), c.titolo[i]);

      // NON sostituisco l'input file; mostro solo il nome a lato
      showFilenameNextToFileInput(
        document.getElementById(`enti_preposti_file${idx}`),
        c.file_titoli[i]
      );
    }
  } else if (tipo_cantierabilita === "necessita-forse"){
    // ... (lascia invariato) ...
    // quando c'è un documento richiesto:
    // showFilenameNextToFileInput(document.getElementById(`documento_abilitativo_${i+1}_1`), c.file_titoli[i]);
  }
}

function showFilenameNextToFileInput(fileInput, name){
  if (!fileInput) return;
  let badge = fileInput.parentElement.querySelector(".excel-filename");
  if (!badge){
    badge = document.createElement("small");
    badge.className = "excel-filename d-block text-muted";
    fileInput.parentElement.appendChild(badge);
  }
  badge.textContent = name || "";
}

function replace_with_input_text(old_input){
  const i = document.createElement('input');
  i.type = 'text'; i.id = old_input.id; i.className = old_input.className;
  old_input.parentNode.replaceChild(i, old_input);
}

// selezione automatica tipo beneficiario + cantierabilità
function select_beneficiario(a){
  if (a.n_imprese){ tipo_beneficiario="associati"; }
  else if (a.cuaa_comune){ tipo_beneficiario="comuni"; }
  else { tipo_beneficiario="singoli"; }
  write_radio(document.getElementsByName("tipo_beneficiario"), tipo_beneficiario, bubbleEvent);
}

function select_cantierabilita(c){
  if (c.stato?.includes("non necessita")) tipo_cantierabilita = "no-necessita";
  else if (c.stato?.includes("sono stati già rilasciati dagli enti preposti")) tipo_cantierabilita = "necessita";
  else if (c.stato?.includes("NON sono stati ancora rilasciati")) tipo_cantierabilita = "necessita-forse";
  write_radio(document.getElementsByName("acquisizione-pareri"), tipo_cantierabilita, bubbleEvent);
}

// mostra/nasconde blocchi anagrafica
function switch_anagrafica(){
  tipo_beneficiario = $('input[name=tipo_beneficiario]:checked').val();
  $("#anagrafica_associati,#anagrafica_comuni,#anagrafica_singoli").hide();
  if (tipo_beneficiario==="associati") $("#anagrafica_associati").show();
  else if (tipo_beneficiario==="comuni") $("#anagrafica_comuni").show();
  else $("#anagrafica_singoli").show();
}

function get_tipo_beneficiario(){ return $('input[name=tipo_beneficiario]:checked').val(); }
function get_tipo_cantierabilita(){ return $("input[name='acquisizione-pareri']:checked").val(); }

// ==========================
//  Mostra/Nascondi Registro IVA per Comuni
// ==========================
function toggleRegistroIva(){
  const t = $("input[name='tipo_beneficiario']:checked").val();
  if (t==="comuni"){ $("#campo_libro_registro_iva").hide(); $("#registro_iva").val(""); }
  else { $("#campo_libro_registro_iva").show(); }
}
$(document).on("change","input[name='tipo_beneficiario']", toggleRegistroIva);

// ===================================================================
//  Sezione CREAZIONE EXCEL (window.getExcelBlob) + ZIP + PDF (crea_pdf_blob)
//  --- qui incolla pari pari la tua implementazione aggiornata ---
//  [Per brevità: ho lasciato invariato tutto il blocco che mi hai passato,
//   con i fix già presenti (tb/ct safe, header, sheet2/3, allegati, etc.).
//   Assicurati di includere qui il blocco completo di getExcelBlob,
//   validaSezioneDocumentazione, check_* e crea_pdf_blob come nella tua
//   versione funzionante.]
// ===================================================================

// === QUI INCOLLA il BLOCCO che hai già (window.getExcelBlob, crea_pdf_blob, check_*, ecc.) ===
// ... [il tuo blocco “crea_files.js” aggiornato] ...

